/*
 * Decompiled with CFR 0.152.
 */
package de.fhapp.jme.scrap;

import de.fhapp.jme.scrap.ListDevices;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MidiExample {
    JFrame frm;
    JLabel lblChannel;
    JTextField txtChannel;
    private JTextArea outArea;
    private JLabel lblNoteValue;
    private JTextField txtNoteValue;
    private JLabel lblVelocity;
    private JTextField txtVelocity;
    private JLabel lblNoteLength;
    private JTextField txtNoteLength;
    private JButton btnListDevices;
    private JLabel lblDeviceIndex;
    private JTextField txtDeviceIndex;
    private Component btnConnect;
    MidiDevice currentDev = null;
    Receiver rcvr;
    private JButton btnSendNote;

    private JLabel buildLabel(String labelText) {
        Dimension theDim = new Dimension(150, 25);
        JLabel lbl = new JLabel(labelText);
        lbl.setPreferredSize(theDim);
        return lbl;
    }

    private JTextField buildTextField(String defaultText) {
        Dimension theDim = new Dimension(40, 25);
        if (defaultText == null) {
            defaultText = "";
        }
        JTextField txt = new JTextField(defaultText);
        txt.setPreferredSize(theDim);
        return txt;
    }

    private JButton buildButton(String buttonText, int action) {
        Dimension theDim = new Dimension(100, 25);
        JButton btn = new JButton(buttonText);
        btn.setPreferredSize(theDim);
        btn.addActionListener(new myAL(action));
        return btn;
    }

    private void output(String theText) {
        this.outArea.append(theText);
        this.outArea.append("\n");
    }

    private void connectDevice() {
        MidiDevice.Info[] devInfos = MidiSystem.getMidiDeviceInfo();
        try {
            int devIndex = Integer.parseInt(this.txtDeviceIndex.getText());
            this.currentDev = MidiSystem.getMidiDevice(devInfos[devIndex]);
            if (!this.currentDev.isOpen()) {
                this.currentDev.open();
            }
            if (this.currentDev.getMaxReceivers() == 0) {
                this.output("The device " + devInfos[devIndex].getName() + " is not a receiver.");
                return;
            }
            this.rcvr = this.currentDev.getReceiver();
            this.output("Connected to " + devInfos[devIndex].getName());
        }
        catch (NumberFormatException ne) {
            this.output(ne.getLocalizedMessage());
        }
        catch (MidiUnavailableException mue) {
            this.output(mue.getLocalizedMessage());
        }
    }

    private void sendNote() {
        ShortMessage sm = new ShortMessage();
        try {
            int channel = Integer.parseInt(this.txtChannel.getText());
            int noteVal = Integer.parseInt(this.txtNoteValue.getText());
            int velo = Integer.parseInt(this.txtVelocity.getText());
            int noteLength = Integer.parseInt(this.txtNoteLength.getText());
            sm.setMessage(144, channel - 1, noteVal, velo);
            this.rcvr.send(sm, -1L);
            Thread.sleep(noteLength);
            sm.setMessage(128, channel - 1, noteVal, velo);
        }
        catch (NumberFormatException ne) {
            this.output(ne.getLocalizedMessage());
        }
        catch (InvalidMidiDataException imde) {
            this.output(imde.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            this.output(ie.getLocalizedMessage());
        }
    }

    private void buildFrame() {
        this.frm = new JFrame();
        this.frm.setSize(280, 600);
        this.frm.setTitle("Midi Example");
        this.frm.addWindowListener(new myWL());
        Container cont = this.frm.getContentPane();
        cont.setLayout(new FlowLayout());
        this.btnListDevices = this.buildButton("list", 0);
        cont.add(this.btnListDevices);
        this.btnConnect = this.buildButton("Connect", 1);
        cont.add(this.btnConnect);
        this.lblDeviceIndex = this.buildLabel("Device index:");
        cont.add(this.lblDeviceIndex);
        this.txtDeviceIndex = this.buildTextField("0");
        cont.add(this.txtDeviceIndex);
        this.lblChannel = this.buildLabel("Channel (1-16):");
        cont.add(this.lblChannel);
        this.txtChannel = this.buildTextField("1");
        cont.add(this.txtChannel);
        this.lblNoteValue = this.buildLabel("Note value:");
        cont.add(this.lblNoteValue);
        this.txtNoteValue = this.buildTextField("60");
        cont.add(this.txtNoteValue);
        this.lblVelocity = this.buildLabel("Velocity:");
        cont.add(this.lblVelocity);
        this.txtVelocity = this.buildTextField("80");
        cont.add(this.txtVelocity);
        this.lblNoteLength = this.buildLabel("Note length (ms):");
        cont.add(this.lblNoteLength);
        this.txtNoteLength = this.buildTextField("1000");
        cont.add(this.txtNoteLength);
        this.btnSendNote = this.buildButton("Send note", 3);
        cont.add(this.btnSendNote);
        this.outArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.outArea);
        sp.setPreferredSize(new Dimension(260, 400));
        cont.add(sp);
        this.frm.setVisible(true);
    }

    public static void main(String[] args) {
        MidiExample me = new MidiExample();
        me.buildFrame();
    }

    private class myAL
    implements ActionListener {
        private int action;

        private myAL(int action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            switch (this.action) {
                case 0: {
                    MidiExample.this.output(ListDevices.listMidiDevices());
                    break;
                }
                case 1: {
                    MidiExample.this.connectDevice();
                    break;
                }
                case 3: {
                    MidiExample.this.sendNote();
                    break;
                }
                default: {
                    MidiExample.this.output("Unknown action " + this.action + "\n");
                }
            }
        }
    }

    private class myWL
    extends WindowAdapter {
        private myWL() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            System.exit(0);
        }
    }
}

